<?php
if ( ! session_id() ) @ session_start();

header("Access-Control-Allow-Origin: *");

include_once('../home.php');

$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
$dbconn = pg_connect($conn_string);

$data = getData($_GET);

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

echo ($callback ? $callback . '(' : '') . $data . ($callback ? ')' : '');

function getData($arr){
    extract($arr);
    
    $fil = array();
    $ord = array();
    
    $data = array();
    $coes = array();
    
    $sql = 'SELECT * FROM public.estacion INNER JOIN public.edo_estacion ON (estacion.id_edo_estacion = edo_estacion.id_edo_estacion) INNER JOIN public.estacion_situacion ON (estacion.id_situacion_estacion = estacion_situacion.id_situacion_estacion) WHERE nu_lat_estacion is not null AND nu_lon_estacion is not null';

    $eesss = pg_query($sql);
    $rows = pg_num_rows($eesss);
    //if ($rows > 0) {
        while ($eess = pg_fetch_assoc($eesss)) {
            $r = 0;
            $lat = floatval($lat);
            $lon = floatval($lon);
            $eslat = floatval($eess['nu_lat_estacion']);
            $eslon = floatval($eess['nu_lon_estacion']);

            $r = distanceCalculation($lat, $lon, $eslat, $eslon,'km', 2);

            if ($r <= $rad ) {
                $tgs = $eess['nu_lts_91']+$eess['nu_lts_95'];
                $ttk = $eess['nu_cap_tkg91']+$eess['nu_cap_tkg95'];
                $ttg = ($tgs*100)/$ttk;
                $ceg = 'red';
                if ($ttg > 50) {
                    $ceg = 'green';
                }elseif ($ttg > 25 && $ttg <= 50) {
                    $ceg = 'orange';
                }elseif ($ttg > 5 && $ttg <= 25) {
                    $ceg = 'darkred';
                }
                if ($eess['id_edo_estacion'] != 1) {
                    $ceg = 'black';
                }
                $eess['color'] = $ceg;
                $eess['radio'] = $r;

                $reg = array();
                $reg[] = base64_encode($eess['id_estacion']);
                $reg[] = base64_encode($eess['color']);
                $reg[] = base64_encode($eslat);
                $reg[] = base64_encode($eslon);
                $reg[] = base64_encode($eess['tx_nom_estacion']);
                $reg[] = base64_encode($eess['tx_dir_estacion']);
                $reg[] = base64_encode($eess['co_estacion']);

                $coes[] = $eess['co_estacion'];
                        
                $data[] = $reg;
            }
        }
    //}
    
    if (isset($ced)) { //&& isset($nac)
        //PRIORIZADOS
        $sql = 'SELECT * FROM public.estacion INNER JOIN estacion_priorizado ON (estacion_priorizado.co_estacion = estacion.co_estacion) INNER JOIN public.edo_estacion ON (estacion.id_edo_estacion = edo_estacion.id_edo_estacion) INNER JOIN public.estacion_situacion ON (estacion.id_situacion_estacion = estacion_situacion.id_situacion_estacion) WHERE nu_lat_estacion is not null AND nu_lon_estacion is not null AND estacion_priorizado.nu_ced_persona = \''.$ced.'\'';// AND estacion_priorizado.in_nac_persona = \''.$nac.'\'';
        //$eesss = dbManager::evalSQL($sql);
        $eesss = pg_query($sql);
        //if (count($eesss) > 0) {
            while ($eess = pg_fetch_assoc($eesss)) {
                $r = 0;
                $lat = floatval($lat);
                $lon = floatval($lon);
                $eslat = floatval($eess['nu_lat_estacion']);
                $eslon = floatval($eess['nu_lon_estacion']);

                $tgs = $eess['nu_lts_91']+$eess['nu_lts_95'];
                $ttk = $eess['nu_cap_tkg91']+$eess['nu_cap_tkg95'];
                $ttg = ($tgs*100)/$ttk;
                $ceg = 'blue';
                
                if ($eess['id_edo_estacion'] != 1) {
                    $ceg = 'black';
                }
                $eess['color'] = $ceg;
                $eess['radio'] = $r;

                if (!in_array($eess['co_estacion'],$coes)) {
                    $reg = array();
                    $reg[] = base64_encode($eess['id_estacion']);
                    $reg[] = base64_encode($eess['color']);
                    $reg[] = base64_encode($eslat);
                    $reg[] = base64_encode($eslon);
                    $reg[] = base64_encode($eess['tx_nom_estacion']);
                    $reg[] = base64_encode($eess['tx_dir_estacion']);
                    $reg[] = base64_encode($eess['co_estacion']);
                            
                    $data[] = $reg;
                }    
            }
        //}
    }
    
    return json_encode($data);
}

function distanceCalculation($point1_lat, $point1_long, $point2_lat, $point2_long, $unit = 'km', $decimals = 2) {
    // Cálculo de la distancia en grados
    $degrees = rad2deg(acos((sin(deg2rad($point1_lat))*sin(deg2rad($point2_lat))) + (cos(deg2rad($point1_lat))*cos(deg2rad($point2_lat))*cos(deg2rad($point1_long-$point2_long)))));

    // Conversión de la distancia en grados a la unidad escogida (kilómetros, millas o millas naúticas)
    switch($unit) {
        case 'km':
            $distance = $degrees * 111.13384; // 1 grado = 111.13384 km, basándose en el diametro promedio de la Tierra (12.735 km)
            break;
        case 'mi':
            $distance = $degrees * 69.05482; // 1 grado = 69.05482 millas, basándose en el diametro promedio de la Tierra (7.913,1 millas)
            break;
        case 'nmi':
            $distance =  $degrees * 59.97662; // 1 grado = 59.97662 millas naúticas, basándose en el diametro promedio de la Tierra (6,876.3 millas naúticas)
    }
    return round($distance, $decimals);
}

?>