<?php
include_once(dirname(__FILE__).'/adodb5/adodb.inc.php');
include_once(dirname(__FILE__).'/adodb5/adodb-exceptions.inc.php');
define('USE_MULTIPLE_CONN',false);
define('SEARCH_PATH','');

class dbManager {

  private static $search_path;
  private static $config_file;
  private static $path_to_locator;
  private static $query_logging;
  private static $db; //note to the new version: now this member is an array
  
  public static function materializaSQL($usr,$nom,$qry,$idx,$tmp=true){
	$query = "SELECT * FROM pg_tables WHERE tablename= '".$usr.$nom."'";
	$tabla = self::evalSQL($query);
	/*if (count($tabla)>0 && !$tmp){
		$drop = "DROP TABLE tmp.".$usr.$nom; 
		self::evalSQL($drop);
	}*/
	if ($tmp == true && count($tabla) == 0){
		//self::desmaterializa($usr);
		$query = "CREATE TEMPORARY TABLE ".$usr.$nom." AS ".$qry;
		self::evalSQL($query);
		$query = "CREATE INDEX fki_".$usr.$nom." ON ".$usr.$nom." USING btree (".$idx.")";
		self::evalSQL($query);
		$query = "VACUUM ANALYZE ".$usr.$nom;
		self::evalSQL($query);

	}elseif ($tmp == false && count($tabla) == 0){
		//self::desmaterializa($usr);
		$query = "CREATE TABLE tmp.".$usr.$nom." AS ".$qry;
		self::evalSQL($query);
		$query = "CREATE INDEX fki_".$usr.$nom." ON tmp.".$usr.$nom." USING btree (".$idx.")";
		self::evalSQL($query);
		$query = "VACUUM ANALYZE tmp.".$usr.$nom;
		self::evalSQL($query);
	}
	return true;
  }
  
  public static function materializa($usr,$nomv,$idx,$tmp=true){
	$query = "SELECT * FROM pg_views WHERE viewname LIKE '%".$nomv."%'";
	$vistas = self::evalSQL($query);
	$tabla = array();
	
	foreach ($vistas as $vista){
		$viewname = substr($vista['viewname'],1);
		$query = "SELECT * FROM pg_tables WHERE tablename= '".$usr.$viewname."'";
		$tabla = self::evalSQL($query);
		
		
		
		if (count($tabla)==0 && $tmp == true){
			$query = "CREATE TEMPORARY TABLE ".$usr.$viewname." AS SELECT * FROM ".$vista['viewname'];
			self::evalSQL($query);
			$query = "CREATE INDEX fki_".$usr.$viewname." ON ".$usr.$viewname." USING btree (".$idx.")";
			self::evalSQL($query);
			$query = "VACUUM ANALYZE ".$usr.$viewname;
			self::evalSQL($query);
		}else if (count($tabla)==0 && $tmp == false){
			$query = "CREATE TABLE tmp.".$usr.$viewname." AS SELECT * FROM ".$vista['viewname'];
			self::evalSQL($query);
			$query = "CREATE INDEX fki_".$usr.$viewname." ON tmp.".$usr.$viewname." USING btree (".$idx.")";
			self::evalSQL($query);
			$query = "VACUUM ANALYZE tmp.".$usr.$viewname;
			self::evalSQL($query);
		}
	}
	return true;
  }
  
  public static function desmaterializa($usr){
	$query = "SELECT * FROM pg_tables WHERE tablename LIKE '".$usr."%'";
	$tablas = self::evalSQL($query);
	foreach ($tablas as $tabla){
		$drop = "DROP TABLE tmp.".$tabla['tablename']; 
		self::evalSQL($drop);
	}
	return true;
  }
  
  public static function setQueryLogging($query_logging = true){
    self::$query_logging = $query_logging;
  }

  public static function Affected_Rows(){
    return self::$db[0]->Affected_Rows();
  }

  public function dbManager($config_file = '', $path_to_locator = ''){
    if ($config_file !== '') {
      self::$config_file = $config_file;
    }
    if ($path_to_locator !== '') {
      self::$path_to_locator = $path_to_locator;
    }
    self::$db = false;
    return true;
  }

  public static function configFile($config_file = ''){
    if ($config_file !== '') {
      $oldconfig = self::$config_file;
      self::$config_file = $config_file;
      return $oldconfig;
    }
    return self::$config_file;
  }

  public static function path2Locator($path_to_locator = ''){
    if ($path_to_locator !== '') {
      $oldpath = self::$path_to_locator;
      self::$path_to_locator = $path_to_locator;
      return $oldpath;
    } else
      return self::$path_to_locator;
  }
  
  public static function searchPath($search_path = ''){
    if ($search_path !== '') {
      $oldsearch_path = self::$search_path;
      self::$search_path = $search_path;
      return $oldsearch_path;
    } else
      return self::$search_path;
  }

  public static function getConnected($multiple = USE_MULTIPLE_CONN){

    $driver = null;
    $username = null;
    $password = null;
    $hostname = null;
    $hostport = null;
    $databasename = null;
    $option = null;
    $mtable = null;
    $lines = file(self::$config_file);

    foreach ($lines as $line){
      $ini = strpos($line,':');
      if ($ini !== false){
        $name = trim(substr($line,0,$ini));
        $end = strpos($line,'#');
        if ($end === false)
          $$name = trim(substr($line,$ini+1));
        else
          $$name = trim(substr($line,$ini+1,$end-$ini-1));
      }
    }
    try {
		$hostname = IPS;
      	$ret[0] = NewADOConnection("$driver://$username:$password@$hostname:$hostport/$databasename?$option");
    } catch (Exception $e) {
      self::$db = null;
      return self::$db;
    }
    if ($multiple === true && strlen($mtable) > 0){
      try {
        $rs = $ret[0]->Execute('SELECT * FROM '.$mtable);
        $rs = $rs->GetArray();
      } catch (Exception $e) {
        echo($e);
      }
      foreach ($rs as $row) {
        try {
        	$re = NewADOConnection($row['driver'].'://'.$row['username'].':'.$row['password'].
        	'@'.$row['hostname'].':'.$row['hostport'].'/'.$row['databasename'].'?'.$row['option']);
        } catch (Exception $e) {
          echo($e);
          $re = $row['id'].'failed.sql';
        }
        $ret[$row['id']] = $re;
      }
    }
    self::$db = $ret;
    return self::$db;
  }

  public static function evalSQLVM($locator,$usr,$args = false,$tmp=true){
	$multiple = USE_MULTIPLE_CONN;
	$atpos = strpos($locator,'@');
    if ($atpos !== false){
      $what = '--'.trim(substr($locator,0,$atpos));
      $where = trim(substr($locator,$atpos+1));
      $lines = file(self::$path_to_locator.$where.'.sql');
      $read = false;
      $tmpSql = '';
      foreach ($lines as $line){
//        if (strpos($line,'--') !== false && $read)
        if ($read)
          $tmpSql .= ' '. trim($line);
        if (strpos($line,';') !== false && $read)
          break;
        if (strpos($line,$what) === 0 && strlen(trim($line)) === strlen($what))
          $read = true;
      }
    }else{
		$tmpSql = $locator;
	}
    $pos1 = strpos($tmpSql,'/*');
    $pos2 = 0;
    $iter = 0;
    $sql = '';
    while ($pos1 !== false){
      $sql .= trim(substr($tmpSql,$pos2,$pos1-$pos2)) . ' ? ';
      $pos2 = strpos($tmpSql,'*/',$pos1) + 2;
      $pos3 = strpos($tmpSql,'/*',$pos2);

      // inicio de soporte de porcentajes para el LIKE
      // la cadena substr($tmpSql,$pos2,$pos3-$pos2) contiene el dummy
      $dummy = substr($tmpSql,$pos2,$pos3-$pos2);
      if (strpos($dummy,"'%") !== false){
        if($args !== false && array_key_exists($iter,$args))
          $args[$iter] = '%'.$args[$iter];
        else
          if($args === false){
            $args = array();
            $args[$iter] = "%";
          }
          else
            $args[$iter] = "%";
      }
      if (strpos($dummy,"%'") !== false){
        if($args !== false && array_key_exists($iter,$args))
          $args[$iter] .= '%';
        else
          if($args === false){
            $args = array();
            $args[$iter] .= "%";
          }
          else
            $args[$iter] .= "%";
      }
      // fin de soporte para porcentajes

      $pos2 = strpos($tmpSql,'*/',$pos2 + 1) + 2;
      $pos1 = strpos($tmpSql,'/*',$pos2);
      $iter++;
    }
    $sql .= trim(substr($tmpSql,$pos2));
	$tab = trim(substr($sql,strpos(strtoupper($sql),'FROM')+4));
	$tab = trim(substr($tab,0,strpos($tab,' ')));
	if ($tmp == true) $tabvm = $usr.$tab; else $tabvm = 'tmp.'.$usr.$tab;
	$sql = str_replace($tab,$tabvm,$sql);

    if(!is_array(self::$db))
      self::getConnected($multiple);
	return self::Execute($sql,$args);
  }

  
  public static function evalSQL($locator,$args = false,$search_path = SEARCH_PATH, $multiple = USE_MULTIPLE_CONN){

    $atpos = strpos($locator,'@');
    if ($atpos !== false){
      $what = '--'.trim(substr($locator,0,$atpos));
      $where = trim(substr($locator,$atpos+1));
      $lines = file(self::$path_to_locator.$where.'.sql');
      $read = false;
      $tmpSql = '';
      foreach ($lines as $line){
//        if (strpos($line,'--') !== false && $read)
        if ($read)
          $tmpSql .= ' '. trim($line);
        if (strpos($line,';') !== false && $read)
          break;
        if (strpos($line,$what) === 0 && strlen(trim($line)) === strlen($what))
          $read = true;
      }
    }else{
		  $tmpSql = $locator;
	  }
    $pos1 = strpos($tmpSql,'/*');
    $pos2 = 0;
    $iter = 0;
    $sql = '';
    while ($pos1 !== false){
      $sql .= trim(substr($tmpSql,$pos2,$pos1-$pos2)) . ' ? ';
      $pos2 = strpos($tmpSql,'*/',$pos1) + 2;
      $pos3 = strpos($tmpSql,'/*',$pos2);

      // inicio de soporte de porcentajes para el LIKE
      // la cadena substr($tmpSql,$pos2,$pos3-$pos2) contiene el dummy
      $dummy = substr($tmpSql,$pos2,$pos3-$pos2);
      if (strpos($dummy,"'%") !== false){
        if($args !== false && array_key_exists($iter,$args))
          $args[$iter] = '%'.$args[$iter];
        else
          if($args === false){
            $args = array();
            $args[$iter] = "%";
          }
          else
            $args[$iter] = "%";
      }
      if (strpos($dummy,"%'") !== false){
        if($args !== false && array_key_exists($iter,$args))
          $args[$iter] .= '%';
        else
          if($args === false){
            $args = array();
            $args[$iter] .= "%";
          }
          else
            $args[$iter] .= "%";
      }
      // fin de soporte para porcentajes

      $pos2 = strpos($tmpSql,'*/',$pos2 + 1) + 2;
      $pos1 = strpos($tmpSql,'/*',$pos2);
      $iter++;
    }
    $sql .= trim(substr($tmpSql,$pos2));
    
	  if (self::$search_path != ''){
		  $sqlpath = 'SET search_path TO '.self::$search_path.',public;';
		  self::Execute($sqlpath);
	  }

    //self::Execute("set names 'utf8'");

	  if(!is_array(self::$db))
      self::getConnected($multiple);
    return self::Execute($sql,$args);
  }

  public static function Execute($sql,$args=false) {
    $rs = array();
    foreach (self::$db as $key => $dbIter) {
      if (!is_string($dbIter)) {
        try {
        	$rt = $dbIter->Execute($sql,$args);
          if (get_class($rt) == "ADORecordSet_empty")
            $rs[$key] = $dbIter->Affected_Rows();
          else{
            $rn = $rt->GetArray();
            if(count($rn) > 0)
              $rn[0]['connId'] = "$key";
            $rs = array_merge($rs,$rn);
          }
        } catch (Exception $e) {
          echo($e);
          $rs = 0;
        }
      }
    }
    return $rs;
  }

  public static function mergeSQL($sql,$args) {
    if (!is_array($args)) {
    	return $sql;
    }
    $statement = strtok($sql,'?');
  	foreach ($args as $item) {
  		if(is_string($item))
  		  $item = "'$item'";
		  if ($item === true)
		  	$item = 'true';
		  if ($item === false)
		  	$item = 'false';
		  $statement .= $item;
		  $statement .= strtok('?');
  	}
  	return $statement;
  }

  public static function StartTrans($transType = 'SERIALIZABLE'){
    foreach (self::$db as $dbIter) {
      if (!is_string($dbIter)) {
        try {
          $dbIter->setTransactionMode($transType);
      	  $dbIter->StartTrans();
        } catch (Exception $e) {
          echo($e);
        }
      }
    }
  }

  public static function CompleteTrans(){
    foreach (self::$db as $dbIter) {
      if (!is_string($dbIter)) {
        try {
          $dbIter->CompleteTrans();
        } catch (Exception $e) {
          echo($e);
        }
      }
    }
  }

}

class genera{
	public static function consulta($tablaprin='',$esquema='public',$filtro=null,$orden=null,$limit=null,$offset=null){
		if($esquema=='') $esquema='public';
		if($tablaprin!=''){
			$qry = new genquery();
			$qry->perfilsc = $esquema;
			$qry->tabla = $tablaprin;
			if (count($filtro)>0) $qry->filtro = $filtro;
			if (count($orden)>0) $qry->orderby = $orden;

      $sql = $qry->consulta();
      //echo $sql;
      if (!is_null($limit))
        $sql .= ' LIMIT '.$limit;
      if (!is_null($offset))
        $sql .= ' OFFSET '.$offset;
      
			return $sql;
		}else
			return '';
	}
	public static function eliminar($tablaprin='',$esquema='public',$filtro=null){
		
		if($esquema=='') $esquema='public';
		if($tablaprin!=''){
			$qry = new genquery();
			$qry->perfilsc = $esquema;
			$qry->tabla = $tablaprin;
			if (count($filtro)>0) $qry->filtro = $filtro;
			return $qry->elimina();
		}else
			return '';
	}
	public static function actualizar($tablaprin='',$esquema='public',$campos=null,$filtro=null){
		
		if($esquema=='') $esquema='public';
		if($tablaprin!=''){
			$qry = new genquery();
			$qry->perfilsc = $esquema;
			$qry->tabla = $tablaprin;
			if (count($filtro)>0) $qry->filtro = $filtro;
			if (count($campos)>0) $qry->campos = $campos;
			return $qry->actualiza();
		}else
			return '';
	}
	public static function insertar($tablaprin='',$esquema='public',$campos=null){
		
		if($esquema=='') $esquema='public';
		if($tablaprin!=''){
			$qry = new genquery();
			$qry->perfilsc = $esquema;
			$qry->tabla = $tablaprin;
			if (count($campos)>0) $qry->campos = $campos;
			return $qry->inserta();
		}else
			return '';
	}
}

class genquery{

	var $perfilcf;
	var $perfilbd;
	var $perfilsc;
	var $tabla;
	var $idconex;
	var $conex;
	var $queryalt;		//QUERY ALTERNO PARA EJECUTAR
	var $tablasc = array();
	var $campo = array();
	var $tipo = array();
	var $longitud = array();
	var $clave = array();
	var $tipoconsulta;
	var $verquery = false; //PERMITE VISUALIZAR LA CONSULTA ARMADA...
	var $modifica = 'N'; //PERMITE VISUALIZAR LA CONSULTA ARMADA...
	
	var $constr = array(); //DATOS DE LAS TABLAS RELACIONADAS
	var $campos = array(); //ARREGLO DE LAS TABLAS CON SUS RESPECTIVOS CAMPOS
	var $tabrel = array(); //NOMBRE DE LAS TABLAS RELACIONADAS
	var $tabenc = array(); //NOMBRE DE LAS TABLAS RELACIONADAS
	var $tabdes = array(); //COMENTARIO DE CADA TABLA RELACIONADA
	var $nodrel = array(); //CÓDIGO DE LAS TABLAS RELACIONADAS
	var $indrel = array(); //INDICA SI LA TABLA ES PRINCIPAL O FORANEA
	var $nurelp = array(); //CONTIENE LOS ATTNUM DE LOS CAMPOS QUE CONFORMAN LA CLAVE EN CADA TABLA
	var $nurelf = array(); //CONTIENE LOS ATTNUM QUE LOS CAMPOS DE CLAVE OCUPAN EN LAS TABLAS FORANEAS
	var $coltab = array(); //CONTIENE LAS COLUMNAS DE CADA TABLA
	var $condic = array(); //CONDICIONES PARA EL WHERE
	var $filtro = array(); //CONDICIONES COMPLETAS PARA EL WHERE
	var $indpri;		   //CONTIENE EL INDICE DE LA TABLA PRINCIPAL	
	var $rempla = array(); //REMPLAZAR DENTRO DEL QUERY GENERADO
	var $orderby = array();
	var $regpag = 10;		// NÚMERO DE REGISTROS QUE SE DEBEN MOSTRAR POR CADA PÁGINA
	var $regini = 0;		//REGISTRO INICIAL PARA LA SENTENCIA LIMIT
	var $cantreg = 0;		//CANTIDAD DE REGISTROS QUE CONTIENE LA CONSULTA
	var $pagact = 1;		//INDICA CUAL ES EL NÚMERO ACTUAL DE LA PÁGINA
	var $paginar = '';		//ESTRUCTURA DE LA PAGINACIÓN DE LA LISTA EN LA PÁGINA
	var $cantpag = 1;		//CANTIDAD TOTAL DE PAGINAS
	var $ejecut = true;
	var $tipojoin = 'INNER';
	var $logrol = '';
	
	var $separg = ',';		//CARÁCTER UTILIZADO COMO SEPARADOR DE LOS ARGUMENTOS
	
	/*function conecta() {
		$this->conex = new conexion;
		$this->idconex = $this->conex->conecta();
	}*/
	
	/*function desconecta() {
		pg_close($this->idconex); 
	}*/
		
	function ejecselect(){
		
		$lista = array();
		
		//$this->conecta();
		//$resp = pg_query($this->idconex,$this->consulta());
		$resp = dbManager::evalSQL($this->consulta());
		//$this->desconecta();
		$j=0;
		while ($reg=pg_fetch_assoc($resp)){
			$lista[$j]=$reg;
			$j++;
		}
		
		pg_free_result($resp);
		
		//$this->oculto();
		return $lista;
	}
	
	function materializa($logrol){
		$query = "SELECT * FROM pg_views WHERE viewowner = '".$logrol."'";
		$vistas = dbManager::evalSQL($query);
		$tabla = array();
		
		foreach ($vistas as $vista){
			$existe = false;
			
			$query = "SELECT * FROM pg_tables WHERE tablename= 't".$vista['viewname'];
			$tabla = dbManager::evalSQL($query);
			if (count($tabla)>0){
				$drop = "DROP TABLE t".$vista['viewname']; 
				dbManager::evalSQL($drop);
			}
			$query = "CREATE TEMPORARY TABLE t".$vista['viewname']." AS SELECT * FROM ".$vista['viewname'];
			dbManager::evalSQL($query);
		}
		return true;
	}
	
	function es_vista($tabla){
		$query = "SELECT UPPER(relkind) as vista FROM PG_CLASS WHERE UPPER(relname) = UPPER('".$tabla."')";
		$resp = dbManager::evalSQL($query);
		if ($resp[0]['vista'] == 'V') $ret = true; else $ret = false;
		return $ret;
	}
	
	function constraint(){

		if ($this->es_vista($this->tabla)){
			$queryconstraint = "SELECT DP.REFOBJID as RELFILENODE, CL.RELNAME, 'p' as CONTYPE, '{1}' as CONKEY, '{}' as CONFKEY, md5(CL.RELNAME) as encriptada FROM PG_CLASS CL,PG_DEPEND DP WHERE (CL.RELNAME = '".$this->tabla."' OR md5(CL.RELNAME) = '".$this->tabla."') AND DP.CLASSID = 1247 AND DP.REFCLASSID = 1259 AND DP.OBJID = CL.RELTYPE;";
		}else{
			$queryconstraint = "SELECT (CASE WHEN CO.CONFRELID = 0 THEN CO.CONRELID ELSE CO.CONFRELID END) as RELFILENODE, CLF.RELNAME, CO.CONTYPE, CO.CONKEY, CO.CONFKEY, md5(CLF.RELNAME) as encriptada FROM PG_CLASS CL,PG_DEPEND DP,PG_CONSTRAINT CO,PG_CLASS CLF,PG_DEPEND DPF WHERE (CL.RELNAME = '".$this->tabla."' OR md5(CL.RELNAME) = '".$this->tabla."') AND DP.CLASSID = 1247 AND DP.REFCLASSID = 1259 AND CO.CONTYPE <> 'u'	AND DP.OBJID = CL.RELTYPE AND CO.CONRELID = DP.REFOBJID AND DPF.REFOBJID = (CASE WHEN CO.CONFRELID = 0 THEN CO.CONRELID ELSE CO.CONFRELID END) AND CLF.RELTYPE = DPF.OBJID ORDER BY CO.CONKEY";
		}
		
    $resp = dbManager::evalSQL($queryconstraint);
		$j=0;
		foreach ($resp as $reg){
			if (!in_array($reg['relname'],$this->tabrel)){
				$this->tabrel[$j]=$reg['relname'];
				$this->tabenc[$j]=$reg['encriptada'];
				$this->nodrel[$j]=$reg['relfilenode'];
				$this->indrel[$j]=$reg['contype'];
				$this->nurelp[$j]=$reg['conkey'];
				$this->nurelf[$j]=$reg['confkey'];
				$this->columnas($this->nodrel[$j]);
				$j++;
			}
		}
	}
	
	function columnas($oidtabla){
		
		if ($this->es_vista($this->tabla)){
			$querycolumnas = "SELECT DISTINCT AT.ATTNAME as columna, TY.TYPNAME as tipo,(CASE WHEN AT.ATTTYPMOD-4 < 0 THEN 0 ELSE AT.ATTTYPMOD-4 END) as longitud, AT.ATTNUM as num, md5(AT.ATTRELID||AT.ATTNAME) as encriptada FROM PG_ATTRIBUTE AT,PG_TYPE TY WHERE AT.ATTTYPID = TY.TYPELEM AND AT.ATTNUM > 0 AND AT.ATTTYPID <> 0 AND AT.ATTRELID = $oidtabla ORDER BY AT.ATTNUM";
		}else{
			$querycolumnas = "SELECT DISTINCT AT.ATTNAME as columna,TY.TYPNAME as tipo,(CASE WHEN AT.ATTTYPMOD-4 < 0 THEN 0 ELSE AT.ATTTYPMOD-4 END) as longitud,AT.ATTNUM as num,md5(AT.ATTRELID||AT.ATTNAME) as encriptada FROM PG_ATTRIBUTE AT,PG_TYPE TY,PG_INDEX IX WHERE AT.ATTTYPID = TY.TYPELEM AND TY.TYPARRAY = 0 AND IX.INDRELID = AT.ATTRELID AND AT.ATTNUM > 0 AND AT.ATTTYPID <> 0 AND AT.ATTRELID = $oidtabla ORDER BY AT.ATTNUM";
		}
		
		//$resp = pg_query($this->idconex,$querycolumnas);
		$resp = dbManager::evalSQL($querycolumnas);
		$j=0;
		foreach ($resp as $reg){
		//while ($reg=pg_fetch_assoc($resp)){
			$this->coltab[$oidtabla][$reg['num']]=$reg;
			$j++;
		}
		//$this->coltab = array_unique($this->coltab);
		//pg_free_result($resp);
		return $resp;
	}
	
	function primaria(){
		
		$indp = 0;
		for($i=0;$i<count($this->tabrel);$i++){
			if ($this->indrel[$i] == 'p'){
				$indp = $i;
				$this->indpri = $indp;
				break;
			}
		}
		$this->indpri = $indp;
	}
	function mergeColumn(){
		$nomcol = array();
		$setcol = '';
		for($i=0;$i<count($this->tabrel);$i++){
			
			$resp = $this->columnas($this->nodrel[$i]);
			foreach ($resp as $reg){
				if (!in_array($reg['columna'],$nomcol)){
					$nomcol[] = $reg['columna'];
					$setcol .= $this->tabrel[$i].'.'.$reg['columna'].',';
				}
			}
		}
		$setcol = substr($setcol,0,strlen($setcol)-1);
		return $setcol;
	}
	function consulta(){

		$cadfrom = ' FROM ';
		$leftjoin = '';
		$cadwhere = ' WHERE ';
		$limite = '';
		$indp = 0;
		$orden = ' ORDER BY ';
		$clp = array();
		$clf = array();
		$c1 = '';
		$c2 = '';
		$flag = 0;

		/*CREACION DEL ARCHIVO DE .PHP DB*/
    $filename = PER . $this->perfilsc . "/";

    if (!file_exists($filename)) {
      mkdir(PER . $this->perfilsc, 0755);
    }

    $filename .= $this->tabla.'.php';

    if (!file_exists($filename)) {
      $tipojoin = $this->tipojoin;
  		
      $this->constraint();
  		$this->primaria();
  		
  		$select = 'SELECT *, row_number() over(#) as idselect';
  		
  		$cadfrom .= $this->perfilsc.".".$this->tabrel[$this->indpri];
  		
  		for($i=0;$i<count($this->tabrel);$i++){
  			
  			$clp = explode(",",str_replace("}","",str_replace("{","",$this->nurelp[$i])));
  			$clf = explode(",",str_replace("}","",str_replace("{","",$this->nurelf[$i])));
  			
  			if ($this->indrel[$i] != 'p'){
  				$leftjoin .= " ".$this->tipojoin." JOIN ".$this->perfilsc.".".$this->tabrel[$i];
  				for($j=0;$j<count($clp);$j++){
  					$c1 = $this->coltab[$this->nodrel[$this->indpri]][$clp[$j]]['columna'];
  					$c2 = $this->coltab[$this->nodrel[$i]][$clf[$j]]['columna'];
  					//if ($c1 != $c2){
  						$c1 = $this->tabrel[$this->indpri].'.'.$c1;
  						$c2 = $this->tabrel[$i].'.'.$c2;
  						$leftjoin .=  " ON (".$c1." = ".$c2.")";
  					//}else
  						//$leftjoin .=  " USING (".$this->tabrel[$i].'.'.$c1.")";
  				}
  			}else{
  				for($j=0;$j<count($clp);$j++){
  					for($k=0;$k<count($this->coltab[$this->nodrel[$this->indpri]]);$k++){
  						if  (($this->coltab[$this->nodrel[$this->indpri]][$k]['num'] == $clp[$j]) && (!empty($this->condic[$this->coltab[$this->nodrel[$this->indpri]][$k]['columna']]))){
  							$cadwhere .= $this->tabrel[$this->indpri].".".$this->coltab[$this->nodrel[$this->indpri]][$k]['columna']." = '".$this->condic[$this->coltab[$this->nodrel[$this->indpri]][$k]['columna']]."' AND ";
  							break;
  						}
  					}
  				}
  			}
  		}
      //GENERA EL ARCHIVO
      $myfile = fopen($filename, "a") or die("no se puede crear el archivo!");

      $txt = '<?php'.chr(10);
      $txt .= '/*'.chr(10);
      $txt .= '--'.strtoupper('SELECT_'.$this->perfilsc.'_'.$this->tabla).chr(10);
      $txt .= $select.$cadfrom.$leftjoin.';'.chr(10);
      $txt .= '*/'.chr(10);
      $txt .= '?>'.chr(10);
      
      fwrite($myfile, $txt);
      fclose($myfile);
    }

    /*LECTURA DEL ARCHIVO DE CONSULTA*/
    $lines = file($filename,FILE_SKIP_EMPTY_LINES);
    $read = false;
    $select = '';
    foreach ($lines as $line){
      if ($read)
        $select .= ' '. trim($line);
      if (strpos($line,';') !== false && $read)
        break;
      if (strpos($line,'--'.strtoupper('SELECT_'.$this->perfilsc.'_'.$this->tabla)) !== false && !$read)
        $read = true;
    }
    $select = trim($select);
    $select = substr($select,0,strlen($select)-1);

		for($i=0;$i<count($this->filtro);$i++){
			$cadwhere .= $this->filtro[$i]." AND ";
		}
		
		if (count($this->filtro) > 0){
			$cadwhere = substr($cadwhere, 0, strlen($cadwhere) - 4);
			$select .= $cadwhere; //$cadfrom.$leftjoin.$cadwhere;
		}

		for($i=0;$i<count($this->orderby);$i++){
			$pos = strpos($this->orderby[$i],'.');
			if ($pos !== false || !isset($this->tabrel[$this->indpri]))
				$orden .= $this->orderby[$i].',';
			else
        $orden .= $this->tabrel[$this->indpri].'.'.$this->orderby[$i].',';
		}
		$orden = substr($orden,0,-1);
		if (count($this->orderby) > 0){
			$select .= $orden;
			$select = str_replace('#',$orden,$select);
		}else
			$select = str_replace('#','',$select);
		
		return $select;
	}
	
	function reemplazar($cadena){
		$ccad = array();
		$ccad = explode(';',$this->rempla[$i]);
		for($i=0;$i<count($this->rempla);$i++){
			$cadena = str_replace($ccad[0],$ccad[1],$cadena);
		}
		return $cadena;
	}
	
	function actualiza(){
		
		$set='';
		$where=' WHERE ';
		//$this->constraint();
		//$this->primaria();
		
		$queryupdate = "update ".$this->perfilsc.".".$this->tabla." set ";
		//echo $queryupdate;
		foreach($this->campos as $campo){
			$set .= $campo.'=/**/0/**/, ';
		}
		$set = substr($set,0,strlen($set)-2);
		
		for($i=0;$i<count($this->filtro);$i++){
			$where .= $this->filtro[$i]." AND ";
		}
		if (count($this->filtro) > 0){
			$where = substr($where, 0, strlen($where) - 4);
			//$queryupdate .= $set.$where;
		}
		
		$queryupdate .= $set.$where;
		
		return $queryupdate;
	}
	
	function elimina(){
		
		//$this->constraint();
		//$this->primaria();
		
		$querydelete = 'DELETE FROM '.$this->perfilsc.".".$this->tabla;
		$cadwhere = ' WHERE ';
		
		for($i=0;$i<count($this->filtro);$i++){
			$cadwhere .= $this->filtro[$i]." AND ";
		}
		if (count($this->filtro) > 0){
			$cadwhere = substr($cadwhere, 0, strlen($cadwhere) - 4);
			$querydelete .= $cadwhere;
		}
		return $querydelete;
	}
	
	function inserta(){
		
		$camp='';
		$valor='';
		
		//$this->constraint();
		//$this->primaria();
		
		$queryinsert = 'INSERT INTO '.$this->perfilsc.".".$this->tabla;
		
		foreach($this->campos as $campo){
			$camp .= $campo.', ';
			$valor .= '/**/0/**/, ';
		}
		$camp = substr($camp,0,strlen($camp)-2);
		$valor = substr($valor,0,strlen($valor)-2);
		$queryinsert .= '('.$camp.') VALUES ('.$valor.')';
		
		return $queryinsert;
	}	
	
	function noquery($valor){
		$np = array('SELECT','INSERT','INTO','DROP','TRUNCATE','HAVING','ORDER','--',' AND ',' OR ');
		if (count($valor) > 0){
			foreach($np as $iq){
				foreach($valor as $val){
					if(strpos($val,$iq) !== false){
						return false;
					}
				}
			}
		}
		return true;
	}
}
?>