    
    function isMobile(){
        return (
            (navigator.userAgent.match(/Android/i)) ||
            (navigator.userAgent.match(/webOS/i)) ||
            (navigator.userAgent.match(/iPhone/i)) ||
            (navigator.userAgent.match(/iPod/i)) ||
            (navigator.userAgent.match(/iPad/i)) ||
            (navigator.userAgent.match(/BlackBerry/i))
        );
    }
    
    var varScroll = 0;

    function ajustarMapa (z){
        var wh = $(window).height();
        var hc = $("#cabecera").height();
        var mt = $("#mapTit").height();
        var htm = wh - hc - mt - 70;
        $("#map").height(htm);
        map.flyTo([mapLat, mapLon], z);
    }

    function setScrollCab(){
        $("body, html").animate({
            scrollTop: $("#cabecera").position().top
        },3000);
    }

    function setScrollPos(id){
        document.getElementById(id).scrollIntoView({
            behavior: 'smooth'
          });
    }

    function loginResize (){
        var back = $('.paper-back-full');
        var size = $(window).height();// - 35;
        back.css('min-height', size + "px");
    }

    function __(Id){
        return document.getElementById(Id);   
    }

    function actChange(obj) {
        $('#'+obj.id).prop( "checked", true );
        $('#'+obj.id).trigger('change');
    }

    function cuerpoResize(){
        var nav = $('.navbar');
        var full = $('#header-full');
        var wrap = $('.wrap-primary');
        var bottom = $('footer');

        var sizeTop = nav.offset().top + nav.height();
        var sizeWrap = $(window).height() - sizeTop;//- bottom.height()
        
        wrap.css('min-height', sizeWrap + "px");
    }

    function spin(){
        var cuerpo = $('#cuerpo');
        var $loader = $( "<div id='loader'></div>" );
        cuerpo.append($loader);
        $('#loader').css('display','block');
    }
    
    var addPopupCas = function(marker){
        marker.on('click', function(e){
            var dato = e.target.options.popupData.split(':');
            $('#msgModalMun').empty();
            $('#videoModalMun').css("display","none");
            $.getJSON('jsonp.php?estruc='+dato[0]+'&id='+dato[1],function(data){
                $.each( data, function( key, val ) {
                    var descaso = val['tx_desc_caso'].replace("\r","\n");
                    var descseg = val['tx_desc_caso_seguido'].replace("\r","\n");
                    var niv = val['co_ubic_caso'].split(',');
                    $("#iconTit").removeClass().addClass(dato[2]);
                    $("#titModalMun").text(val['tx_nom_caso_categoria']);
                    $('#msgModalMun').append('<p><strong>De:</strong> '+val['tx_nom_persona']+'</p>');
                    $('#msgModalMun').append('<p><strong>ID SP3:</strong> '+val['co_sp3_caso']+'</p>');
                    $('#msgModalMun').append('<p><strong>Asunto:</strong> <a href="#" onclick="verCaso('+val['id_caso']+');"> '+val['tx_asun_caso']+'</a> <a id="'+val['tx_link_caso']+'" href="#" onclick="getAccion(this);"> <i class="fas fa-map-marked-alt"></i> '+niv[0]+' ('+niv[1]+')</a></p>');
                    $('#msgModalMun').append('<p><strong>Descripción:</strong> '+descaso.replace("\n","</br>")+'</p>');
                    $('#msgModalMun').append('<p><strong>Estatus:</strong> '+val['tx_nom_edo_caso']+' '+val['fe_act_caso_seguido']+'</p>');
                    $('#msgModalMun').append('<p><strong>Observación:</strong> '+descseg.replace("\n","</br>")+'</p>');
                    $('#msgModalMun').append('<p><strong>Responsable:</strong> '+val['responsable']+'</p>');
                });
                
            }).done(function() {
                $("#myModal").modal("show");
                $(".btn").attr("disabled", false);
                $( "#myModal" ).draggable()
            });
                $('body').css("padding-right","");
        });
    };



    var addPopupEESS = function(marker){
        marker.on('click', function(e){
            var dato = e.target.options.popupData.split(':');
            $('#msgModalMun').empty();
            $('#videoModalMun').css("display","none");
            $.getJSON('jsonp.php?estruc='+dato[0]+'&id='+dato[1],function(data){
                $.each( data, function( key, val ) {
                    var descseg = val['tx_dir_estacion'].replace("\r","\n");

                    if (val['tx_nom_persona'] == null) val['tx_nom_persona'] = '';
                    if (val['nu_telf1_persona'] == null) val['nu_telf1_persona'] = '';
                    if (val['nu_telf2_persona'] == null) val['nu_telf2_persona'] = '';

                    if (val['nu_lts_91'] == null) val['nu_lts_91'] = 0;
                    if (val['nu_lts_95'] == null) val['nu_lts_95'] = 0;
                    if (val['nu_lts_dsl'] == null) val['nu_lts_dsl'] = 0;

                    var pc91 = val['nu_cap_tkg91']>0?(val['nu_lts_91']*100)/val['nu_cap_tkg91']:0;
                    var pc95 = val['nu_cap_tkg95']>0?(val['nu_lts_95']*100)/val['nu_cap_tkg95']:0;
                    var pcds = val['nu_cap_tkdsl']>0?(val['nu_lts_dsl']*100)/val['nu_cap_tkdsl']:0;

                    var st91 = 'red';
                    var st95 = 'red';
                    var stds = 'red';

                    if (pc91 > 50) {
                        st91 = 'green';
                    }else if (pc91 > 25 && pc91 <= 50) {
                        st91 = 'orange';
                    }else if (pc91 > 5 && pc91 <= 25) {
                        st91 = 'darkred';
                    }
                    if (pc95 > 50) {
                        st95 = 'green';
                    }else if (pc95 > 25 && pc95 <= 50) {
                        st95 = 'orange';
                    }else if (pc95 > 5 && pc95 <= 25) {
                        st95 = 'darkred';
                    }
                    if (pcds > 50) {
                        stds = 'green';
                    }else if (pcds > 25 && pcds <= 50) {
                        stds = 'orange';
                    }else if (pcds > 5 && pcds <= 25) {
                        stds = 'darkred';
                    }
                    
                    $("#iconTit").removeClass().addClass(dato[2]);
                    $("#titModalMun").text(val['tx_nom_estacion']);
                    $('#msgModalMun').append('<p><strong>Estado:</strong> '+val['tx_nom_estado']+'</p>');
                    $('#msgModalMun').append('<p><strong>Municipio:</strong> '+val['tx_nom_municipio']+'</p>');
                    $('#msgModalMun').append('<p><strong>Parroquia:</strong> '+val['tx_nom_parroquia']+'</p>');
                    $('#msgModalMun').append('<p><strong>Dirección:</strong> '+descseg.replace("\n","</br>")+'</p>');
                    $('#msgModalMun').append('<table>');
                    $('#msgModalMun').append('<tr>');
                    $('#msgModalMun').append('<td width="120px"><span style="color:blue"><strong>Combustible</strong></span></td><td width="80px" align="center"><strong>Tanques</strong></td><td width="80px" align="center"><strong>Cap.(lts)</strong></td><td width="80px" align="center"><strong>Existencia</strong></td><td width="60px" align="center"><strong>Poct.(%)</strong></td><td width="20px"></td>');
                    $('#msgModalMun').append('</tr>');
                    $('#msgModalMun').append('<tr>');
                    $('#msgModalMun').append('<td><strong>Gasolina 91</strong></td><td align="center">'+val['nu_tk_g91']+'</td><td align="right">'+number_format (val['nu_cap_tkg91'], 0, ',', '.')+'</td><td align="right">'+number_format (val['nu_lts_91'], 0, ',', '.')+'</td><td align="right">'+number_format (pc91, 1, ',', '.')+'%</td><td align="right"><i class="fas fa-gas-pump" style="color:'+st91+'"></i></td>');
                    $('#msgModalMun').append('</tr>');
                    $('#msgModalMun').append('<tr>');
                    $('#msgModalMun').append('<td><strong>Gasolina 95</strong></td><td align="center">'+val['nu_tk_g95']+'</td><td align="right">'+number_format (val['nu_cap_tkg95'], 0, ',', '.')+'</td><td align="right">'+number_format (val['nu_lts_95'], 0, ',', '.')+'</td><td align="right">'+number_format (pc95, 1, ',', '.')+'%</td><td align="right"><i class="fas fa-gas-pump" style="color:'+st95+'"></i></td>');
                    $('#msgModalMun').append('</tr>');
                    if (val['nu_tk_dsl'] > 0) {
                        $('#msgModalMun').append('<tr>');
                        $('#msgModalMun').append('<td><strong>Gasoil</strong></td><td align="center">'+val['nu_tk_dsl']+'</td><td align="right">'+number_format (val['nu_cap_tkdsl'], 0, ',', '.')+'</td><td align="right">'+number_format (val['nu_lts_dsl'], 0, ',', '.')+'</td><td align="right">'+number_format (pcds, 1, ',', '.')+'%</td><td align="right"><i class="fas fa-gas-pump" style="color:'+stds+'"></i></td>');
                        $('#msgModalMun').append('</tr>');
                    }
                    
                    $('#msgModalMun').append('</table>');
                    $('#msgModalMun').append('<p><strong>Responsable:</strong> '+val['tx_nom_persona']+'</p>');
                    $('#msgModalMun').append('<p><strong>Telefóno:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                });
                
            }).done(function() {
                $("#myModal").modal("show");
                $(".btn").attr("disabled", false);
                $( "#myModal" ).draggable()
            });
                $('body').css("padding-right","");
        });
    };

    function onClickREDI(cod) {
        $('#msgModalMun').empty();
        $('#videoModalMun').css("display","none");
        $.getJSON('jsonp.php?estruc=redi&id='+cod ,function(data){
            $.each( data, function( key, val ) {
                $("#iconTit").removeClass().addClass('fas fa-user');
                $("#titModalMun").text('DRMM '+val['tx_nom_redi']);
                $('#msgModalMun').append('<p><strong>Jefe de DRMM:</strong> '+val['tx_abr_jerarquia']+' '+val['tx_nom_persona']+' <i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_persona']+',\'per\');"></i></p>');
                $('#msgModalMun').append('<p><strong>Cédula:</strong> '+val['in_nac_persona']+'-'+val['nu_ced_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Teléfono:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Email:</strong> '+val['tx_email_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Mensaje a las JDMM\'s de la DRMM:</strong> <i class="fas fa-layer-group" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_redi']+',\'zodi\');"></i><i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_redi']+',\'zodi\');"></i></p>');
                $('#msgModalMun').append('<p><strong><a id=\"p_nacional\" onclick=\"getAccion(this);\" href=\"#\">CEOFANB</a></strong></p>');
                $('#msgModalMun').append('<p><strong>DRMM:</strong> <a id=\"p_redi_'+val['id_redi']+'\" onclick=\"getAccion(this);\" href=\"#\">'+val['tx_nom_redi']+'</a></p>');
            });
            
        }).done(function() {
            $("#myModal").modal("show");
            $(".btn").attr("disabled", false);
        });
    };

    function onClickEdoEsri(cod) {
        $('#msgModalMun').empty();
        $('#videoModalMun').css("display","none");
        $.getJSON('jsonp.php?estruc=edoesri&id='+cod ,function(data){
            $.each( data, function( key, val ) {

                $("#iconTit").removeClass().addClass('fas fa-user');
                $("#titModalMun").text('ESTADO '+val['tx_nom_estado']);
                $('#msgModalMun').append('<p><strong>Nombre:</strong> '+val['tx_nom_persona']+' <i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_persona']+');"></i></p>');
                $('#msgModalMun').append('<p><strong>Cédula:</strong> '+val['in_nac_persona']+'-'+val['nu_ced_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Teléfono:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Email:</strong> '+val['tx_email_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Mensaje a los Municipios del Estado</strong> <i class="fas fa-layer-group" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_estado']+',\'adi\');"></i><i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_estado']+',\'adi\');"></i></p>');
                $('#msgModalMun').append('<p><strong><a id=\"p_nacional\" onclick=\"getAccion(this);\" href=\"#\">Nacional</a></strong></p>');
                $('#msgModalMun').append('<p><strong>Estado:</strong> <a id=\"p_zodi_'+val['co_estado']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_estado']+'</a></p>');
            });
            
        }).done(function() {
            $("#myModal").modal("show");
            $(".btn").attr("disabled", false);
        });
    };

    function onClickEDO(cod) {
        $('#msgModalMun').empty();
        $('#videoModalMun').css("display","none");
        $.getJSON('jsonp.php?estruc=zodi&id='+cod ,function(data){
            $.each( data, function( key, val ) {

                $("#iconTit").removeClass().addClass('fas fa-user');
                $("#titModalMun").text('ESTADO '+val['tx_nom_estado']);
                $('#msgModalMun').append('<p><strong>Nombre:</strong> '+val['tx_nom_persona']+' <i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_persona']+');"></i></p>');
                $('#msgModalMun').append('<p><strong>Cédula:</strong> '+val['in_nac_persona']+'-'+val['nu_ced_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Teléfono:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Email:</strong> '+val['tx_email_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Mensaje a los Municipios del Estado</strong> <i class="fas fa-layer-group" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_estado']+',\'adi\');"></i><i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_estado']+',\'adi\');"></i></p>');
                $('#msgModalMun').append('<p><strong><a id=\"p_nacional\" onclick=\"getAccion(this);\" href=\"#\">Nacional</a></strong></p>');
                $('#msgModalMun').append('<p><strong>Estado:</strong> <a id=\"p_zodi_'+val['co_estado']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_estado']+'</a></p>');
            });
            
        }).done(function() {
            $("#myModal").modal("show");
            $(".btn").attr("disabled", false);
        });
    };

    function onClickMUN(cod) {
        $('#msgModalMun').empty();
        $('#videoModalMun').css("display","none");
        $.getJSON('jsonp.php?estruc=municipio&id='+cod ,function(data){
            $.each( data, function( key, val ) {
                $("#iconTit").removeClass().addClass('fas fa-user');
                $("#titModalMun").text('MUNICIPIO '+val['tx_nom_municipio']);
                $('#msgModalMun').append('<p><strong>Nombre:</strong> '+val['tx_nom_persona']+' <i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['id_persona']+');"></i></p>');
                $('#msgModalMun').append('<p><strong>Cédula:</strong> '+val['in_nac_persona']+'-'+val['nu_ced_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Teléfono:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Email:</strong> '+val['tx_email_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Mensaje a las Parroquias del Municipio:</strong> <i class="fas fa-layer-group" style="cursor:pointer;color:red;" onclick="editaMsg('+val['co_adi']+',\'apdi\');"></i><i class="fas fa-envelope" style="cursor:pointer;color:red;" onclick="editaMsg('+val['co_adi']+',\'apdi\');"></i></p>');
                $('#msgModalMun').append('<p><strong><a id=\"p_nacional\" onclick=\"getAccion(this);\" href=\"#\">Nacional</a></strong></p>');
                $('#msgModalMun').append('<p><strong>Estado:</strong> <a id=\"p_zodi_'+val['co_estado']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_estado']+'</a></p>');
                $('#msgModalMun').append('<p><strong>Municipio:</strong> <a id=\"p_municipio_'+val['co_municipio']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_municipio']+'</a></p>');
            });
            
        }).done(function() {
            $("#myModal").modal("show");
            $(".btn").attr("disabled", false);
        });
    };

    function onClickPAR(cod) {
        $('#msgModalMun').empty();
        $('#videoModalMun').css("display","none");
        $.getJSON('jsonp.php?estruc=parroquia&id='+cod ,function(data){
            $.each( data, function( key, val ) {
                $("#iconTit").removeClass().addClass('fas fa-user');
                $("#titModalMun").text('PARROQUIA '+val['tx_nom_parroquia']);
                $('#msgModalMun').append('<p><strong>Nombre:</strong> '+val['tx_nom_persona']+' <i class="fas fa-envelope" style="cursor:pointer;color:blue;" onclick="editaMsg('+val['id_persona']+');"></i></p>');
                $('#msgModalMun').append('<p><strong>Cédula:</strong> '+val['in_nac_persona']+'-'+val['nu_ced_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Teléfono:</strong> '+val['nu_telf1_persona']+' / '+val['nu_telf2_persona']+'</p>');
                $('#msgModalMun').append('<p><strong>Email:</strong> '+val['tx_email_persona']+'</p>');
                $('#msgModalMun').append('<p><strong><a id=\"p_nacional\" onclick=\"getAccion(this);\" href=\"#\">Nacional</a></strong></p>');
                $('#msgModalMun').append('<p><strong>Estado:</strong> <a id=\"p_zodi_'+val['co_estado']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_estado']+'</a></p>');
                $('#msgModalMun').append('<p><strong>Municipio:</strong> <a id=\"p_municipio_'+val['co_municipio']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_municipio']+'</a></p>');
                $('#msgModalMun').append('<p><strong>Parroquia:</strong> <a id=\"p_apdi_'+val['co_apdi']+'\" onclick=\"getPag(this);\" href=\"#\">'+val['tx_nom_parroquia']+'</a></p>');
            });
            
        }).done(function() {
            $("#myModal").modal("show");
            $(".btn").attr("disabled", false);
        });
    };

    function editaMsg(ind,loc){
        setTimeout(function(){
            $("#btnModal").trigger('click');
            $("#p_mensaje_sal").trigger("click");
            var msgid = 'q_mensaje_nuevo_'+loc+'_'+ind;
            if(__(msgid) == null){
                $("input").append('<input id="'+msgid+'" type="text" value="'+msgid+'"/>');
            }
            getPag(__(msgid));
            
        },500);
    }

    //GENERACIÓN DE LISTAS EN DISPOSITIVOS MOVILES
    function optsel(uri,cod,sel){
        var str = encodeURI(uri);
        var x = document.getElementById(sel);
        var ul = document.getElementById("dynamic-list");
        var i;
        for(i = x.options.length - 1 ; i >= 0 ; i--){
            x.remove(i);
        }
        ul.innerHTML = "";
        $.getJSON('jsonm.php?estruc='+str+'&id='+cod ,function(data){
            $.each(data, function(key, value) {
                if (isMobile()) {
                    x.style.visibility = 'hidden';
                    if (key < 100) {
                        var li = document.createElement("li");
                        li.setAttribute('id',value['nombre']);
                        li.appendChild(document.createTextNode(value['nombre']));
                        ul.appendChild(li);
                    }
                }else{
                    x.style.visibility = 'visible';
                    var option = document.createElement("option");
                    option.text = value['nombre'];
                    option.value = value['id'];
                    x.add(option, x[key]);
                }
            });
        });
    }

    function verCaso(id){
        var pcas = 'p_caso_'+id;
        var vcas = 'q_caso_ver_'+id;
        $("#p_caso").attr("id",pcas);
        $("#myModal").modal("toggle");
        setTimeout(() => {
            getPag(__(pcas));
        }, 500);
        setTimeout(() => {
            getPag(__(vcas));
        }, 1000);
        setTimeout(() => {
            $("#"+pcas).attr("id","p_caso");
        }, 3000);
    }

    function actEESS(est,per,usr) {
        
        var edo = 3;
        var layerExist = eval('map.hasLayer(estacion)');
        if (layerExist) {
            eval('map.removeLayer(estacion)');
        }
        eval('estacion = L.layerGroup();');
        eval('estacionArr = [];');
        
        if ($("#box_abierta").prop( "checked" ) && $("#box_cerrada").prop( "checked" ) == false) {
            edo = 1;
        }else if ($("#box_abierta").prop( "checked" ) == false && $("#box_cerrada").prop( "checked" )) {
            edo = 2;
        }else if ($("#box_abierta").prop( "checked" ) == false && $("#box_cerrada").prop( "checked" ) == false) {
            edo = 100;
        }

        $.getJSON('jestacion.php?est='+est+'&edo='+edo+'&per='+per+'&usr='+usr,function(data){
            $.each( data, function( k, val ) {
                var marca = 'new L.marker(['+val[2]+', '+val[3]+'], {icon: L.AwesomeMarkers.icon({icon: "gas-pump", prefix: "fa",markerColor: "'+val[1]+'"}), popupData: "estacion:'+val[0]+':fas fa-gas-pump"})';
                eval('est'+k+' = '+marca);
                eval('addPopupEESS(est'+k+');');
                eval('estacionArr.push(est'+k+')');
            });        
        })
        .done(function() {
            eval('estacion = L.layerGroup(estacionArr);');
            eval('estacion.addTo(map);');
        });
    }

    var jestacion;

    function startActEESS() {
        var aper = $('#aper').val();
        var tper = $('#tper').val();
        var iper = $('#iper').val();
        
        $('#j_'+aper).trigger("click");
        actEESS(aper,tper,iper);
        
        jestacion = setInterval(() => {
            $('#j_'+aper).trigger("click");
            actEESS(aper,tper,iper);
        }, 60000);
        intervals.push(jestacion);
    }

    function actCasos(est,per,usr) {
        $.getJSON('jsonp.php?estruc=caso_categoria',function(cats){
            $.each( cats, function( k1, valor ) {
                
                var layerExist = eval('map.hasLayer(caso'+valor['tx_abr_categoria']+')');
                if (layerExist) {
                    eval('map.removeLayer(caso'+valor['tx_abr_categoria']+')');
                }
                
                eval('caso'+valor['tx_abr_categoria']+' = L.layerGroup();');
                eval('caso'+valor['tx_abr_categoria']+'Arr = []');
                
                $.getJSON('jcaso.php?est='+est+'&cat='+valor['id_caso_categoria']+'&per='+per+'&usr='+usr,function(data){
                    $.each( data, function( k, val ) {
                        var marca = 'new L.marker(['+val[4]+', '+val[5]+'], {icon: L.AwesomeMarkers.icon({icon: "'+val[3]+'", prefix: "fa",markerColor: "'+val[2]+'"}), popupData: "caso:'+val[0]+':'+val[1]+'"})';//.addTo(caso'+valor['tx_abr_categoria']+')
                        eval(val[1]+k1+k +' = '+marca);
                        eval('addPopupCas('+val[1]+k1+k+');');
                        eval('caso'+valor['tx_abr_categoria']+'Arr.push('+val[1]+k1+k+')');
                    });        
                })
                .done(function() {
                    eval('caso'+valor['tx_abr_categoria']+' = L.layerGroup(caso'+valor['tx_abr_categoria']+'Arr);');
                    if ($('#box_'+valor['tx_abr_categoria']).prop( 'checked' )) {
                        eval('caso'+valor['tx_abr_categoria']+'.addTo(map);');
                    }
                });
    
               });        
        });
        
    }

    var jcaso;

    function startActCasos() {
        var aper = $('#aper').val();
        var tper = $('#tper').val();
        var iper = $('#iper').val();
        
        $('#j_'+aper).trigger("click");
        actCasos(aper,tper,iper);
        
        jcaso = setInterval(() => {
            $('#j_'+aper).trigger("click");
            actCasos(aper,tper,iper);
        }, 300000);
        intervals.push(jcaso);
    }

    function getPag(obj){

        if(jQuery.type(obj) === "undefined"){
            $("input").append('<input id="'+obj+'" type="hidden" value="'+obj+'"/>');
            obj = __(obj);
        }
        
        var tk = $("#token").val();
        var ul = $("#uslog").val();
        var us = $("#uskey").val();
        var ps = $(window).scrollTop();
        var id = btoa(obj.id);
        var pa = '';

        pa = btoa(pa);
        $.ajax({
            method: "POST",
            url: 'ws.php',
            data: { p: id, t: tk, l: ul, u: us, a: pa},
            dataType: 'html',
            success: function(resp){
                if (obj.id.indexOf('j_') >= 0) {
                    $.each($.parseJSON(resp), function(idx, arr) {
                        if (typeof $('#'+arr.id).attr('href') !== "undefined") {
                            $('#'+arr.id).attr('id',arr.val);
                        }else{
                            $('#'+arr.id).val(arr.val);
                        }
                    });
                }else{
                    var pags = resp.split('**==**');
                    $.each(pags, function(i,nvapag){
                        var sec = nvapag.substr(0,20);
                        var pag = nvapag.substr(20);
                        if ($(sec).attr('type') == 'hidden') {
                            $(sec).val(pag);
                        }else if ($(sec).attr('type') == 'text') {
                            $(sec).val(pag);
                        }else{
                            $(window).scrollTop(ps);
                            $(sec).html(pag);
                        }
                    });
                }
                $(".modal-backdrop").remove();
                $("body").css("padding-right", "0px");
                cuerpoResize ();
            }
        });  
    }

    function getAccion(obj){
        var tk = $("#token").val();
        var ul = $("#uslog").val();
        var us = $("#uskey").val();
        var ps = $(window).scrollTop();
        var id = btoa(obj.id);
        var pa = '';
        var idp = '';
        var err = false;
        var eid = '';

        $('#'+obj.id).attr("disabled", true);
        
        intervals.forEach(clearInterval);
        
        $('#'+obj.id).parents().map(function() {
            if (this.tagName == 'FORM')
                idp = this.id;
        }).get();
        
        if (idp != '') {
            $('form#'+idp+' :input').each(function(){
                if ($(this).attr('id') == 'multiupload') {
                    var fileList = $('#multiupload').prop("files");
                    $('#uploadsts').html('');
                    var i;
                    for ( i = 0; i < fileList.length; i++) {
                        $('#uploadsts').append('<p class="upload-page">'+fileList[i].name+'<span class="loading-prep" id="prog'+i+'"></span></p>');
                        if(i == fileList.length-1){
                            uploadajax(fileList.length-1,0);
                        }
                    }
                }else{
                    pa = pa + $(this).attr('id')+'::'+$(this).val()+';';
                    if ($(this).val() == '' || $(this).val() == null) {
                        if ($("label[for='"+$(this).attr('id')+"']").text().indexOf('*') >= 0) {
                            eid = $(this).attr('id');
                            err = true;
                            return false;
                        }
                    }
                }
            }); 
        }
        if (getError(err,eid)) {
            /*BLOQUEAR BOTONES*/
            $(".btn").attr("disabled", true);
            pa = btoa(pa);
            $.ajax({
                method: "POST",
                url: 'ws.php',
                data: { p: id, t: tk, l: ul, u: us, a: pa},
                dataType: 'html',
                success: function(resp){
                    //$('#loader').remove(); 
                    if (obj.id.indexOf('j_') >= 0) {
                        $.each($.parseJSON(resp), function(idx, arr) {
                            if (typeof $('#'+arr.id).attr('href') !== "undefined") {
                                $('#'+arr.id).attr('id',arr.val);
                            }else{
                                $('#'+arr.id).val(arr.val);
                                $('#'+arr.id).text(arr.val);
                            }
                        });
                    }else{
                        var pags = resp.split('**==**');
                        $.each(pags, function(i,nvapag){
                            var sec = nvapag.substr(0,20);
                            var pag = nvapag.substr(20);

                            if ($(sec).attr('type') == 'hidden') {
                                $(sec).val(pag);
                            }else if ($(sec).attr('type') == 'text') {
                                $(sec).val(pag);
                            }else{
                                $(window).scrollTop(ps);
                                $(sec).html(pag);
                            }
                        });
                    }
                    $("body").css("padding-right", "0px");
                    $(".modal-backdrop").remove();
                    cuerpoResize ();
                    setTimeout(() => {
                        $(".btn").attr("disabled", false);
                    }, 3000);
                    
                }
            });
        }   
    }

    function getError(fe, idc){
        if (fe) {
            var nc = $("label[for='"+idc+"']").text();
            var msg = 'Se debe especificar un valor para '+nc.replace('*','');
            alert(msg);
            return false;
        }
        return true;
    }

    function uploadajax(ttl,cl){

        var fileList = $('#multiupload').prop("files");
        var sf = $('#sufArc').val();
        $('#prog'+cl).removeClass('loading-prep').addClass('upload-image');
    
         var form_data = new FormData();
        form_data.append("upload_image", fileList[cl]);
        form_data.append("sufArc", sf);
    
    
        var request = $.ajax({
                  url: "subir.php",
                  cache: false,
                  contentType: false,
                  processData: false,
                  async: true,
                  data: form_data,
                  type: 'POST', 
                  xhr: function() {  
                      var xhr = $.ajaxSettings.xhr();
                      if(xhr.upload){ 
                      xhr.upload.addEventListener('progress', function(event){
                          var percent = 0;
                          if (event.lengthComputable) {
                              percent = Math.ceil(event.loaded / event.total * 100);
                          }
                          $('#prog'+cl).text(percent+'%') 
                       }, false);
                     }
                     return xhr;
                  },
                  success: function (res, status) {
                      if (status == 'success') {
                          percent = 0;
                          $('#prog' + cl).text('');
                          $('#prog' + cl).text(' --Cargado-- ');
                          if (cl < ttl) {
                              uploadajax(ttl, cl + 1);
                          }
                      }
                  },
                  fail: function (res) {
                      $('#prog' + cl).text(' --Falló la carga-- ');
                  }    
        });
    }

    function validarEmail( email ) {
        expr = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
        if ( !expr.test(email) )
            alert("Error: La dirección de correo " + email + " es incorrecta.");
    }

    function validaApp(id){
        var tk = $("#token").val();
        var ul = $("#uslog").val();
        var us = $("#uskey").val();
        var id = btoa(id);
        $.ajax({
            method: "POST",
            url: "ws.php",
            data: { p: id, t: tk, l: ul, u: us},
            type: 'html',
            async: true,
            success: function(resp){
                var pags = resp.split('**==**');
                $.each(pags, function(i,nvapag){
                    var sec = nvapag.substr(0,20);
                    var pag = nvapag.substr(20);
                    $(sec).html(pag);
                });
            }
        });
    }

    function stopValida(id){
        clearInterval(id);
    }

    function number_format (number, decimals, dec_point, thousands_sep) {
        // http://kevin.vanzonneveld.net
        // +   original by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
        // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
        // +     bugfix by: Michael White (http://getsprink.com)
        // +     bugfix by: Benjamin Lupton
        // +     bugfix by: Allan Jensen (http://www.winternet.no)
        // +    revised by: Jonas Raoni Soares Silva (http://www.jsfromhell.com)
        // +     bugfix by: Howard Yeend
        // +    revised by: Luke Smith (http://lucassmith.name)
        // +     bugfix by: Diogo Resende
        // +     bugfix by: Rival
        // +      input by: Kheang Hok Chin (http://www.distantia.ca/)
        // +   improved by: davook
        // +   improved by: Brett Zamir (http://brett-zamir.me)
        // +      input by: Jay Klehr
        // +   improved by: Brett Zamir (http://brett-zamir.me)
        // +      input by: Amir Habibi (http://www.residence-mixte.com/)
        // +     bugfix by: Brett Zamir (http://brett-zamir.me)
        // +   improved by: Theriault
        // +      input by: Amirouche
        // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
        // *     example 1: number_format(1234.56);
        // *     returns 1: '1,235'
        // *     example 2: number_format(1234.56, 2, ',', ' ');
        // *     returns 2: '1 234,56'
        // *     example 3: number_format(1234.5678, 2, '.', '');
        // *     returns 3: '1234.57'
        // *     example 4: number_format(67, 2, ',', '.');
        // *     returns 4: '67,00'
        // *     example 5: number_format(1000);
        // *     returns 5: '1,000'
        // *     example 6: number_format(67.311, 2);
        // *     returns 6: '67.31'
        // *     example 7: number_format(1000.55, 1);
        // *     returns 7: '1,000.6'
        // *     example 8: number_format(67000, 5, ',', '.');
        // *     returns 8: '67.000,00000'
        // *     example 9: number_format(0.9, 0);
        // *     returns 9: '1'
        // *    example 10: number_format('1.20', 2);
        // *    returns 10: '1.20'
        // *    example 11: number_format('1.20', 4);
        // *    returns 11: '1.2000'
        // *    example 12: number_format('1.2000', 3);
        // *    returns 12: '1.200'
        // *    example 13: number_format('1 000,50', 2, '.', ' ');
        // *    returns 13: '100 050.00'
        // Strip all characters but numerical ones.
        number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
        var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return '' + Math.round(n * k) / k;
        };
        // Fix for IE parseFloat(0.55).toFixed(0) = 0;
        s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
        if (s[0].length > 3) {
            s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
        }
        if ((s[1] || '').length < prec) {
            s[1] = s[1] || '';
            s[1] += new Array(prec - s[1].length + 1).join('0');
        }
        return s.join(dec);
    }

    function difFechas(f1,f2){
        var aFec1 = f1.split('-');
        var aFec2 = f2.split('-');
        var fFec1 = Date.UTC(aFec1[0],aFec1[1]-1,aFec1[2]);
        var fFec2 = Date.UTC(aFec2[0],aFec2[1]-1,aFec2[2]);
        var dif = fFec2 - fFec1;
        var dias = Math.floor(dif/(1000*60*60*24));
        return dias;
    }

    function sumDias(fec,nd){
        fec = fec.split('-');
        //SE PASA A FORMATO mm/dd/yyyy
        fec = fec[1]+'/'+fec[2]+'/'+fec[0];
        var hoy = new Date(fec);
        hoy.setTime(hoy.getTime()+nd*24*60*60*1000);
        var mes = hoy.getMonth()+1;
        if (mes < 10) mes='0'+mes;
        var dia = hoy.getDate();
        if(dia<10){
                dia='0'+dia;
            } 
        var fecha = hoy.getFullYear()+'-'+mes+'-'+dia;
        return fecha
    }

    function abrirModal(){
        $("#nvaClave").modal("show");
        $("#innvo").val(1);
    }

    $('.telefono').mask("(9999) 999-9999");
    $('.cedula').mask('00000000', {reverse: true});
    $('.rif').mask('A-00000000-0');
    $('.fecha').datepicker({
        dateFormat: "yy-mm-dd",
        changeMonth: true,
        changeYear: true
    });

    $("#InputPpalUser").focus();

    $("#InputPpalUser").keyup(function(e){ 
        var code = e.which; // recommended to use e.which, it's normalized across browsers
        if(code==13)e.preventDefault();
        if(code==32||code==13){
            if ($("#InputPpalPass").val().length > 0 ) {
                getAccion(__('q_login_1'));
            }else{
                $("#InputPpalPass").focus();
            }
        }
    });

    $("#InputPpalPass").keyup(function(e){ 
        var code = e.which; // recommended to use e.which, it's normalized across browsers
        if(code==13)e.preventDefault();
        if(code==32||code==13){
            if ($("#InputPpalUser").val().length > 0 ) {
                getAccion(__('q_login_1'));
            }else{
                $("#InputPpalUser").focus();
            }
        }
    });