<?php
date_default_timezone_set('America/Caracas');
set_time_limit (0);
ini_set('memory_limit','250M');

if ( ! session_id() ) @ session_start();

include_once('home.php');

@define('SCH','public');

header('Access-Control-Allow-Origin: *');

$est = isset($_GET['es']) ? $_GET['es'] : '555555';

$data = getData($est);

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

echo ($callback ? $callback . '(' : '') . $data . ($callback ? ')' : '');

function getData($est){

	$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
    $dbconn = pg_connect($conn_string);

    $sql = 'UPDATE movimiento_estacion SET in_print_fact = 1 WHERE id_movimiento_estacion = $1';
    $result = pg_prepare($dbconn, "upd_query", $sql);

    $sql = 'UPDATE movimiento_estacion SET in_print_fact = 9 WHERE id_movimiento_estacion = $1';
    $result = pg_prepare($dbconn, "err_query", $sql);

    $sql = 'SELECT * FROM movimiento_estacion INNER JOIN estacion ON (movimiento_estacion.id_estacion = estacion.id_estacion) INNER JOIN persona ON (movimiento_estacion.in_nac_persona = persona.in_nac_persona AND movimiento_estacion.nu_ced_persona = persona.nu_ced_persona) INNER JOIN parroquia ON (parroquia.id_parroquia = estacion.id_parroquia) WHERE in_print_fact = 0 AND co_estacion = \''.$est.'\' LIMIT 10';
    //echo $sql;
    $result = pg_query($dbconn, $sql);

	$data = array();

	while ($row = pg_fetch_assoc($result)) {

        $sql = 'SELECT COALESCE(sum(nu_cant_combustible), 0) servido, COALESCE(ROUND((avg(nu_lts_cupo_estacion) - sum(nu_cant_combustible)),2), 0) disponible FROM movimiento_estacion INNER JOIN estacion ON (estacion.id_estacion = movimiento_estacion.id_estacion) WHERE date_part(\'month\', fe_dia_movimiento_estacion) = date_part(\'month\', CURRENT_DATE) AND in_nac_persona = \''.$row['in_nac_persona'].'\' AND nu_ced_persona = \''.$row['nu_ced_persona'].'\'';
        $resp = pg_query($dbconn, $sql);
        $cpo = pg_fetch_assoc($resp);
        $msg = 'Reporte de Consumo:\nNombre: '.$row['tx_nom_persona'].'\nCI:'.$row['in_nac_persona'].$row['nu_ced_persona'].'\nCupo del Mes: '.$row['nu_lts_cupo_estacion'].'\nCantidad de Equipada: '.$row['nu_cant_combustible'].' lts.\nTipo: Premiun\nLugar: '.$row['tx_nom_estacion'].'\nTotal Consumo del Mes: '.$cpo['servido'].'\nDisponible: '.$cpo['disponible'].'\nFecha/hora: '.$row['fe_act_movimiento_estacion'];
        
        $linea = array();
        $linea['nombre'] = $row['tx_nom_persona'];
        $linea['ced'] = $row['in_nac_persona'].$row['nu_ced_persona'];
        $linea['telf'] = $row['nu_telf1_persona'];
        $linea['cupo'] = $row['nu_lts_cupo_estacion'];
        $linea['surt'] = $row['nu_cant_combustible'];
        $linea['tipo'] = 'Premiun';
        $linea['eess'] = $row['tx_nom_estacion'];
        $linea['parq'] = $row['tx_nom_parroquia'];
        $linea['tsur'] = $cpo['servido'];
        $linea['disp'] = $cpo['disponible'];
        $linea['fech'] = $row['fe_act_movimiento_estacion'];
        $data[] = $linea;

        //pg_execute($dbconn, "upd_query", array($row['id_movimiento_estacion']));
	}
	return json_encode($data);
}

?>