    var ctx3 = document.getElementById('tvehi').getContext('2d');
    var ctx2 = document.getElementById('tcomb').getContext('2d');
    var ctx = document.getElementById('semana').getContext('2d');
    
    function getTickets(set=0,lim=15){
        var cest = $("#InputOrgCod").val();
        var desd = $("#InputOrgIni").val();
        var hast = $("#InputOrgHas").val();
        var busc = $("#aidbusca").val();
        var ps = $(window).scrollTop();
        
        $.get('jtickets.php?cod='+cest+'&des='+desd+'&has='+hast+'&set='+set+'&lim='+lim+'&bsc='+busc, function(data){
            $("#tab_tickets").html(data);
            $(window).scrollTop(ps);
        });
        
    }
    
    function getTop(set=0,lim=15){
        var cest = $("#InputOrgCod").val();
        var desd = $("#InputOrgIni").val();
        var hast = $("#InputOrgHas").val();
        var busc = $("#aidbusca").val();
        var top = $("#InputTop option:selected").val();
        var uso = $("#InputUso option:selected").val();
        var ps = $(window).scrollTop();
        
        $.get('jtickets.php?cod='+cest+'&des='+desd+'&has='+hast+'&set='+set+'&lim='+lim+'&bsc='+busc+'&top='+top+'&uso='+uso, function(data){
            $("#tab_tickets").html(data);
            $(window).scrollTop(ps);
        });
        
    }
    
    function reset(){
        window.tcomb.destroy();
        window.tvehi.destroy();
        window.myBar.destroy();
    }
    
    function getDatos(){
        var tg91 = [];
        var tg95 = [];
        var tds = [];
        var fec = [];
        var totc = 0;
        var totf = 0;
        var tote = 0;
        var tot91 = 0;
        var tot95 = 0;
        var totds = 0;
        var atend = 0;
        var cest = $("#InputOrgCod").val();
        var desd = $("#InputOrgIni").val();
        var hast = $("#InputOrgHas").val();
        $.getJSON('jconsumo.php?cod='+cest+'&des='+desd+'&has='+hast+'&grp=dia',function(data){
            $.each( data, function( key, val ) {
                fec.push(val['fecha']);
                tg91.push(val['total91']);
                tg95.push(val['total95']);
                tds.push(val['totalds']);
                
                tot91 += parseFloat(val['total91']);
                tot95 += parseFloat(val['total95']);
                totds += parseFloat(val['totalds']);
                totc += parseFloat(val['total']);
                
                totf += parseFloat(val['cantf91']);
                totf += parseFloat(val['cantf95']);
                totf += parseFloat(val['cantfds']);
                
                tote += parseFloat(val['cante91']);
                tote += parseFloat(val['cante95']);
                tote += parseFloat(val['canteds']);
                
                atend += parseFloat(val['atendido']);
            });
        }).done(function() {
            
            var barChartData = {
    		labels: fec,
        		datasets: [{
        			label: 'Gasolina 91',
        			backgroundColor: window.chartColors.blue,
        			data: tg91
        		}, {
        			label: 'Gasolina 95',
        			backgroundColor: window.chartColors.green,
        			data: tg95
        		}, {
        			label: 'Diesel',
        			backgroundColor: window.chartColors.red,
        			data: tds
        		}]
        
        	};
    		
    		var config1 = {
    			type: 'pie',
    			data: {
    				datasets: [{
    					data: [
    						tot91.toFixed(2),
    						tot95.toFixed(2),
    						totds.toFixed(2),
    					],
    					backgroundColor: [
    						window.chartColors.blue,
    						window.chartColors.green,
    						window.chartColors.red,
    					],
    					label: 'Dataset 1'
    				}],
    				labels: [
    					'91',
    					'95',
    					'Diesel'
    				]
    			},
    			options: {
    				responsive: true,
    				legend: {
                        display: true,
                        labels: {
                            fontStyle: 'bold'
                        }
                    }
    			}
    		};
    		
    		var config2 = {
    			type: 'pie',
    			data: {
    				datasets: [{
    					data: [
    						totf.toFixed(2),
    						tote.toFixed(2)
    					],
    					backgroundColor: [
    						window.chartColors.red2,
    						window.chartColors.yellow
    					],
    					label: 'Dataset 1'
    				}],
    				labels: [
    					'Flota',
    					'Externo',
    				]
    			},
    			options: {
    				responsive: true,
    				legend: {
                        display: true,
                        labels: {
                            fontStyle: 'bold'
                        }
                    }
    			}
    		};
    		/*
    		if (typeof window.tcomb != "undefined") {
                window.tcomb.destroy();
    		    window.tvehi.destroy();
    		    window.myBar.destroy();
            }*/
    		
    		window.tcomb = new Chart(ctx2, config1);
    		window.tvehi = new Chart(ctx3, config2);
    		window.myBar = new Chart(ctx, {
    			type: 'bar',
    			data: barChartData,
    			options: {
    				title: {
    					display: true,
    					text: 'Consumo de Combustible en la Estación ('+totc.toFixed(2)+' Lts.)'
    				},
    				tooltips: {
    					mode: 'index',
    					intersect: false
    				},
    				responsive: true,
    				scales: {
    					xAxes: [{
    						stacked: true,
    					}],
    					yAxes: [{
    						stacked: true
    					}]
    				}
    			}
    		});
    		
    		var txtCantAtend = '<span style="font-size:80px;color:#D00;">'+atend+'</span>'
    		$("#cantAtendidos").html(txtCantAtend);
        });
    }

$( function() {
    
    $('.cedula').mask('000000000', {reverse: true});
    $( ".modal-backdrop" ).remove();

    $( ".fecha" ).datepicker({
        dateFormat: "yy-mm-dd",
        changeMonth: true,
        changeYear: true
    });

    $('#InputOrgIni').change(function () {
        var dsd = $("#InputOrgIni").val();
        var hst = $("#InputOrgHas").val();
        var cod = $("#InputOrgCod2").text();
        var newUrl = 'aplic/modelo/consumo/x_consumo.php?cod='+cod+'&dsd='+dsd+'&hst='+hst;
        
        $("#x_consumo").attr("href", newUrl);
        $("#IniRepo").val($("#InputOrgIni").val());
    });
    $('#InputOrgHas').change(function () {
        var dsd = $("#InputOrgIni").val();
        var hst = $("#InputOrgHas").val();
        var cod = $("#InputOrgCod2").text();
        var newUrl = 'aplic/modelo/consumo/x_consumo.php?cod='+cod+'&dsd='+dsd+'&hst='+hst;
        
        $("#x_consumo").attr("href", newUrl);
        $("#HasRepo").val($("#InputOrgHas").val());
    });

    $('#box_91').change(function () {
        if ($("#box_91").prop( "checked" )) {
            $("#box_95").prop( "checked",false );
            $("#box_dsl").prop( "checked",false );
            $("#box_tco").val(1);
        }
    });
    $('#box_95').change(function () {
        if ($("#box_95").prop( "checked" )) {
            $("#box_91").prop( "checked",false );
            $("#box_dsl").prop( "checked",false );
            $("#box_tco").val(2);
        }
    });
    $('#box_dsl').change(function () {
        if ($("#box_dsl").prop( "checked" )) {
            $("#box_91").prop( "checked",false );
            $("#box_95").prop( "checked",false );
            $("#box_tco").val(3);
        }
    });
    $('#box_ven').change(function () {
        if ($("#box_ven").prop( "checked" )) {
            $("#box_ext").prop( "checked",false );
            $("#box_nac").val('V');
        }else{
            $("#box_ext").prop( "checked",true );
            $("#box_nac").val('E');
        }
    });
    $('#box_ext').change(function () {
        if ($("#box_ext").prop( "checked" )) {
            $("#box_ven").prop( "checked",false );
            $("#box_nac").val('E');
        }else{
            $("#box_ven").prop( "checked",true );
            $("#box_nac").val('V');
        }
    });
    
    getDatos();
    getTickets(0,15);
});