<?php
if ( ! session_id() ) @ session_start();

header("Access-Control-Allow-Origin: *");

include_once('../home.php');
require_once('../assets/dbManager.php');

@define('SCH','public');

dbManager::setQueryLogging(false);
dbManager::configFile('../assets/dbconfig.php');

header('Access-Control-Allow-Origin: *');

$dts = isset($_GET) ? $_GET : '0';

$data = getData($dts);

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

echo ($callback ? $callback . '(' : '') . $data . ($callback ? ')' : '');

function getData($dts){

	$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
    $dbconn = pg_connect($conn_string);

    //ced,plc,tpp,twt,telf,est,tco
    
    extract($dts);

    $plc = strtoupper($plc);

    $sql = 'SELECT co_estacion, co_ticket, in_semaforo FROM ticket_estacion WHERE in_estado_ticket = 0 AND nu_ced_persona = $1 AND in_nac_persona = $2 AND nu_plc_vehiculo = $3';
    $result = pg_prepare($dbconn, "sel_query", $sql);
    if (!$result) {
        die('No se puede preparar la Consulta...');
    }

    $result = pg_execute($dbconn, "sel_query", array($ced,$nac,$plc));
    if (!$result){
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(pg_last_error($dbconn));
        $data[] = $linea;
        echo json_encode($data);
        exit();
    }
    $rows = pg_num_rows($result);
    if ($rows > 0) {
        $row = pg_fetch_assoc($result);
        $linea = array();
        $linea[] = base64_encode(1);
        $linea[] = base64_encode($row['co_ticket']);
        $linea[] = base64_encode($row['co_estacion']);
        $linea[] = base64_encode($row['in_semaforo']);
        $data[] = $linea;
    }else {
        $linea = array();
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(0);
        $linea[] = base64_encode(0);
        $data[] = $linea;
    }
    

	return json_encode($data);
}

?>