<?php
date_default_timezone_set('America/Caracas');
set_time_limit (0);
ini_set('memory_limit','250M');

if ( ! session_id() ) @ session_start();

include_once('home.php');

@define('SCH','public');

header('Access-Control-Allow-Origin: *');

$est = isset($_GET['es']) ? $_GET['es'] : '555555';

$data = getData($est);

$callback = isset($_GET['callback']) ? preg_replace('/[^a-z0-9$_]/si', '', $_GET['callback']) : false;
header('Content-Type: ' . ($callback ? 'application/javascript' : 'application/json') . ';charset=UTF-8');

echo ($callback ? $callback . '(' : '') . $data . ($callback ? ')' : '');

function getData($est){

	$conn_string = "host=".IPS." port=".DBPORT." dbname=".DBN." user=".DBUSER." password=".DBPASS."";
    $dbconn = pg_connect($conn_string);

    $sql = 'UPDATE movimiento_estacion SET in_env_mensaje = 1 WHERE id_movimiento_estacion = $1';
    $result = pg_prepare($dbconn, "upd_query", $sql);

    $sql = 'UPDATE movimiento_estacion SET in_env_mensaje = 9 WHERE id_movimiento_estacion = $1';
    $result = pg_prepare($dbconn, "err_query", $sql);

    $sql = 'SELECT * FROM movimiento_estacion INNER JOIN estacion ON (movimiento_estacion.id_estacion = estacion.id_estacion) INNER JOIN persona ON (movimiento_estacion.in_nac_persona = persona.in_nac_persona AND movimiento_estacion.nu_ced_persona = persona.nu_ced_persona) WHERE in_env_mensaje = 0 AND co_estacion = \''.$est.'\' LIMIT 100';
    //echo $sql;
    $result = pg_query($dbconn, $sql);

	$data = array();

	while ($row = pg_fetch_assoc($result)) {

        $sql = 'SELECT COALESCE(sum(nu_cant_combustible), 0) servido, COALESCE(ROUND((avg(nu_lts_cupo_estacion) - sum(nu_cant_combustible)),2), 0) disponible FROM movimiento_estacion INNER JOIN estacion ON (estacion.id_estacion = movimiento_estacion.id_estacion) WHERE id_vehiculo_uso = 2  AND date_part(\'month\', fe_dia_movimiento_estacion) = date_part(\'month\', CURRENT_DATE) AND in_nac_persona = \''.$row['in_nac_persona'].'\' AND nu_ced_persona = \''.$row['nu_ced_persona'].'\'';
        $resp = pg_query($dbconn, $sql);
        $cpo = pg_fetch_assoc($resp);
        $msg = 'Reporte de Consumo:\nNombre: '.$row['tx_nom_persona'].'\nCI:'.$row['in_nac_persona'].$row['nu_ced_persona'].'\nCupo del Mes: '.$row['nu_lts_cupo_estacion'].'\nCantidad de Equipada: '.$row['nu_cant_combustible'].' lts.\nTipo: Premiun\nLugar: '.$row['tx_nom_estacion'].'\nTotal Consumo del Mes: '.$cpo['servido'].'\nDisponible: '.$cpo['disponible'].'\nFecha/hora: '.$row['fe_act_movimiento_estacion'];
        
        $row['nu_telf1_persona'] = str_replace('-','',$row['nu_telf1_persona']);
        $row['nu_telf1_persona'] = str_replace(' ','',$row['nu_telf1_persona']);
        $row['nu_telf1_persona'] = str_replace('(','',$row['nu_telf1_persona']);
        $row['nu_telf1_persona'] = str_replace(')','',$row['nu_telf1_persona']);

        if (strlen($row['nu_telf1_persona']) == 11) { //ELIMINA EL CERO INICIAL
            $row['nu_telf1_persona'] = substr($row['nu_telf1_persona'],1);
        }
        if (substr($row['nu_telf1_persona'],0,1) == '4') { //VERIFICA QUE SEA NUMERO CELULAR
            $linea = array();
            $linea['id'] = $row['id_movimiento_estacion'];
            $linea['telf'] = $row['nu_telf1_persona'];
            $linea['msg'] = $msg;
            $data[] = $linea;

            //MARCA LA PERSONA COMO EN PROCESO DE ENVIO DE SMS
            //pg_execute($dbconn, "upd_query", array($row['id_movimiento_estacion']));
        }else {
            //MARCA LA PERSONA COMO ERROR EN NUMERO DE TELEFONO
            //pg_execute($dbconn, "err_query", array($row['id_movimiento_estacion']));
        }
        
	}
	return json_encode($data);
}

?>