<?php
/**
* Controlador de acceso a contenido (Servicio).  Versión: 1.0 
*
* Este controlador se encarga de verificar las solicitudes
* realizadas para entregar contenido de actualización de la 
* Aplicación. Verifica dirección del solicitante, permisos
* de acceso a módulos y datos de usuario antes de entregar
* cualquier contenido.
*
* Utiliza una combinación de PHP y Smarty
*
* @author José G. Pino
* @author https://pinojg.ddns.net
*
*/


if ( ! session_id() ) @ session_start();
header("Access-Control-Allow-Origin: *");

include_once('home.php');
include_once(ASSETS.'utils.php');
require_once(ASSETS.'smarty/libs/Smarty.class.php');
require_once(ASSETS.'PHPExcel/Classes/PHPExcel.php');
require_once(ASSETS.'qr/qrlib.php');
require_once(ASSETS.'dbManager.php');

@define('SCH','public');

dbManager::setQueryLogging(false);
dbManager::configFile(ASSETS.'dbconfig.php');
dbManager::path2Locator(PER);

$pos = strrpos($_SERVER['HTTP_COOKIE'], "=");
$srv = substr($_SERVER['HTTP_COOKIE'],$pos+1);

if ($_COOKIE['PHPSESSID'] != trim($srv)){
    die('sin permiso de acceso...');
}

$token = $_COOKIE['PHPSESSID'];

/*
CASO PARTICULAR DE ENTRADA DE DATOS VIA GET VERIFICADOS
SERÁN AGREGADOS A POST PARA LA EJECUCIÓN CORRESPONDIENTE*/
//VERIFICACIÓN DE TOKEN DE APLICACIÓN
if (isset($_GET['t'])){
    if (desencriptar($_GET['t']) == $token){
        foreach ($_GET as $clave => $valor){
            $_POST[$clave] = $valor;
        }
    }
}
/********************************************************/

if (!empty($_POST)){
    
    $smarty = new Smarty();

    $smarty->setTemplateDir(ASSETS.'smarty/templates');
    $smarty->setCompileDir(TMP);
    $smarty->setCacheDir(ASSETS.'smarty/cache');
    $smarty->setConfigDir(ASSETS.'smarty/configs');
    
    /*Sector de verificación de TOKEN y SESSION seguro*/
    //VERIFICACIÓN DE TOKEN DE APLICACIÓN
   /* if (isset($_POST['t'])){
        if (desencriptar($_POST['t']) != $token){
            die('Sin autorización...');
        }
    }else{
        die('Sin autorización...');
    }*/ //comentado por williams torrealba
    
    //VERIFICACIÓN DE TOKEN DE INICIO DE SESSION DE USUARIO
    if (isset($_POST['u'])){
        $uskey = desencriptar($_POST['u']);
    }
    
    //DECODIFICACIÓN DE LOS ARGUMENTOS
    foreach ($_POST as $key => $value) {
        $_POST[$key] = base64_decode($value);
    }
    
    $_action = explode('_', $_POST['p']);
    
    //CONVERSIÓN DE ARGUMENTOS EN VARIABLES
    if (isset($_POST['a'])) {
        $cadargs = explode(';', $_POST['a']);
        foreach ($cadargs as $cadarg) {
            $args = explode('::', $cadarg);
            $args[1] = urldecode(trim($args[1]));
            ${$args[0]} = $args[1];
            $evar = '_'.$args[0];
            if (strpos($args[0], 'Date') === false) {
                $$evar = encriptar($args[1]);
            }
        }
    }
    //VERIFICACIÓN DE TOKEN DE SESION DE USUARIO
    if (isset($InputPpalUser)) {
        $usract = strtolower($InputPpalUser);
    }else{
        $usract = $_POST['l'];
        $ustd = desencriptar($_SESSION[$usract]);
        if (isset($_SESSION[$usract]) && isset($_POST['u'])) {
            if ( desencriptar($_SESSION[$usract]) != $uskey){
                exit();
            }
        }
    }
    
    $fil['usu'][] = 'UPPER(usuario.co_login) = UPPER(\''.$usract.'\')';
    $sql = genera::consulta('rol_usuario',SCH,$fil['usu']);
    $g_usu = dbManager::evalSQL($sql);
    $g_usu = $g_usu[0];

    /*FIN DEL SECTOR DE VERIFICACIÓN SEGURA*/

    $tipo = $_action[0];
    $tarea = $_action[1];
    if (isset($_action[2])) {
        $aid = $_action[2];
    }
    if (isset($_action[3])) {
        $aid2 = $_action[3];
    }
    if (isset($_action[4])) {
        $aid3 = $_action[4];
    }

    
    //verificacion de permisos
    $fil['per'][] = 'UPPER(modulo.tx_url_modulo) = UPPER(\'p_'.$tarea.'\')';
    $fil['per'][] = 'rol_modulo.id_rol = '.$g_usu['id_rol'];
    $sql = genera::consulta('permiso',SCH,$fil['per']);
    $g_per = dbManager::evalSQL($sql);
    $g_per = $g_per[0]['co_permiso'];
    //fin de verificacion de permisos

    $smarty->template_dir = GUI.$tarea;

    $fil = array();
    $ord = array();

    $pfile = BIZ.$tarea.'/p_'.$tarea.'.php';
    $qfile = BIZ.$tarea.'/q_'.$tarea.'.php';
    $afile = BIZ.$tarea.'/a_'.$tarea.'.php';
    $sfile = BIZ.$tarea.'/s_'.$tarea.'.php';
    $jfile = BIZ.$tarea.'/j_'.$tarea.'.php';
    $xfile = BIZ.$tarea.'/x_'.$tarea.'.php';
    $ofile = BIZ.'opcion/o_'.$tarea.'.php';

    $nop = array('mensaje','caso','rtickets','rol');
    
    switch ($tipo) {
        case 'p': //CARGA DE PAGINAS
            if (file_exists($pfile)) {
                $actp = 'q_'.$tarea;
                $smarty->assign('actp',$actp);
                require_once($pfile);
            }
            break;
        case 'q': //QUERYS / CONSULTAS
            if (file_exists($qfile)) {
                $actp = 'q_'.$tarea;
                require_once($qfile);
                $smarty->assign('actp',$actp);
                if (file_exists($pfile) && !in_array($tarea,$nop)) {
                    $smarty->assign('msgp',$msg);
                    require_once($pfile);
                }
            }
            break;
        case 'a': //ACTUALIZACIONES
            if (file_exists($afile)) {
                $actp = 'q_'.$tarea;
                require_once($afile);
                if (file_exists($pfile)) {
                    $smarty->assign('actp',$actp);
                    $smarty->assign('msgp',$msg);
                    require_once($pfile);
                }
            }
            break;
        case 'o': // Opciones desplegables
            if (file_exists($ofile)) {
                require_once($ofile);
            }
            break;
        case 's':   // LISTADO SOLICITADO
            if (file_exists($sfile)) {
                require_once($sfile);
            }
            break;
        case 'j':   //PRUEBA DE ENVIO TIPO JSON STRING
            if (file_exists($jfile)) {
                require_once($jfile);
            }
            break;
        case 'x':   //GENERAR EXCEL
            if (file_exists($xfile)) {
                require_once($xfile);
            }
            break;
        case 't':
            if ($tarea == 'token') {
                $uskt = $usract.':'.mt_rand();
                $uskey = encriptar($uskt);
                $_SESSION[$login] = $uskey;
                $smarty->template_dir = GUI.'login';
                $smarty->assign('uskey',$uskey);

                $div = '#duskey';
                $div = str_pad($div, 20);
                $seg = $div.$smarty->fetch("token.tpl");
            }
            break;
    }
    echo $seg;
}
?>